<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParameterTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('parameter_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parameter_id')->unsigned()->default('null');
			$table->string('name')->nullable()->default('null');
			$table->string('slug');
			$table->string('description');
			$table->string('locale')->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('parameter_translations');
	}
}