<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMasterBankVisibilitiesTable extends Migration {

	public function up()
	{
		Schema::create('master_bank_visibilities', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('client_id')->unsigned();
			$table->bigInteger('master_bank_id')->unsigned();
			$table->tinyInteger('bank_status')->default('1');
			$table->tinyInteger('home_visibility_status')->default('0');
			$table->bigInteger('alternative_bank')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('master_bank_visibilities');
	}
}