<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePasswordChangeHistoryTable extends Migration {

	public function up()
	{
		Schema::create('password_change_history', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('request_id')->unsigned()->nullable();
			$table->string('reset_type', 500)->nullable();
			$table->bigInteger('user_id')->unsigned();
			$table->string('requested_ip', 50);
			$table->tinyInteger('request_status')->default('0');
			$table->datetime('requested_date');
			$table->datetime('processed_date')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('password_change_history');
	}
}