<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountryTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('country_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('country_id')->unsigned();
			$table->string('name', 255);
			$table->string('slug', 255)->nullable();
			$table->string('currency', 255)->nullable();
			$table->string('nationality', 255)->nullable();
			$table->string('locale', 255)->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('country_translations');
	}
}