<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('discount_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('duration');
			$table->longText('reason');
			$table->integer('discount_id')->unsigned();
			$table->string('locale')->index();
		});
	}

	public function down()
	{
		Schema::drop('discount_translations');
	}
}