<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRewardsTable extends Migration {

	public function up()
	{
		Schema::create('rewards', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('added_by_id')->unsigned();
			$table->integer('employee_id')->unsigned();
			$table->integer('branch_id')->unsigned();
			$table->date('date');
			$table->double('total');
			$table->string('status')->default('hold');
		});
	}

	public function down()
	{
		Schema::drop('rewards');
	}
}