<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVacationsTable extends Migration {

	public function up()
	{
		Schema::create('vacations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('added_by_id')->unsigned();
			$table->integer('branch_id')->unsigned();
			$table->integer('year');
			$table->date('start_date');
			$table->date('end_date')->nullable();
			$table->integer('days_count');
		});
	}

	public function down()
	{
		Schema::drop('vacations');
	}
}