<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->timestamps();
			$table->increments('id');
			$table->string('client_id', 50);
			$table->bigInteger('phone');
			$table->string('address', 100);
			$table->decimal('commission');
			$table->enum('payment', array('online', 'cash'));
			$table->decimal('delivery');
			$table->decimal('price');
			$table->decimal('total');
			$table->enum('status', array('call-accept-refuse-confirm-delivery-complete'));
			$table->integer('restaurant_id');
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}