<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('partnerId');
			$table->string('customPackageOrderId');
			$table->string('generatedPackageOrderId');
			$table->float('amount');
			$table->string('currency');
			$table->string('customPackageId')->nullable();
			$table->json('packageAtr');
			$table->string('comment')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}