<?php

namespace Lecture;

use Illuminate\Database\Eloquent\Model;

class Lecture extends Model 
{

    protected $table = 'lectures';
    public $timestamps = true;

    public function course()
    {
        return $this->belongsTo('Course', 'course_id');
    }

    public function students()
    {
        return $this->belongsToMany('LectureStudent', 'student_id');
    }

    public function homework()
    {
        return $this->hasOne('Homework', 'lecture_id');
    }

    public function files()
    {
        return $this->hasMany('File', 'lecture_id');
    }

}