<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Item extends Model 
{

    protected $table = 'items';
    public $timestamps = true;
    protected $fillable = array('title', 'description', 'price', 'discount', 'seller_id', 'availability', 'not_available_reason', 'appear', 'not_appear_reason', 'prepare_time', 'calory');
    protected $visible = array('title', 'description', 'price', 'discount', 'seller_id', 'availability', 'not_available_reason', 'appear', 'not_appear_reason', 'prepare_time', 'calory');

    public function images()
    {
        return $this->hasMany('Image', 'item_id');
    }

    public function seller()
    {
        return $this->belongsTo('Seller', 'seller_id');
    }

    public function extras()
    {
        return $this->hasMany('Extra', 'item_id');
    }

    public function sizes()
    {
        return $this->hasMany('Size', 'item_id');
    }

}