<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Sellercontract extends Model 
{

    protected $table = 'sellercontracts';
    public $timestamps = true;
    protected $fillable = array('from_day', 'to_day', 'percantge', 'paper_contract_image', 'employee_id', 'seller_id', 'notes');
    protected $visible = array('from_day', 'to_day', 'percantge', 'paper_contract_image', 'employee_id', 'seller_id', 'notes');

    public function marketing_employee()
    {
        return $this->belongsTo('Employee', 'employee_id');
    }

    public function seller()
    {
        return $this->belongsTo('Seller', 'seller_id');
    }

}