<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('name', 'phone', 'password', 'image', 'phone_verify', 'device_id', 'device_token', 'api_token', 'verify_code', 'usertype_id', 'role_id', 'block', 'block_reason', 'avatar', 'active', 'appear', 'not_appear_reason', 'wallet_amount');
    protected $visible = array('name', 'phone', 'password', 'image', 'phone_verify', 'device_id', 'device_token', 'api_token', 'verify_code', 'usertype_id', 'role_id', 'block', 'block_reason', 'avatar', 'active', 'appear', 'not_appear_reason', 'wallet_amount');

    public function address()
    {
        return $this->hasMany('Address', 'user_id');
    }

    public function userType()
    {
        return $this->belongsTo('Usertype', 'usertype_id');
    }

    public function wallets()
    {
        return $this->hasMany('Userwallet', 'user_id');
    }

}