<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Workschedule extends Model 
{

    protected $table = 'workschedules';
    public $timestamps = true;
    protected $fillable = array('work_from', 'work_to', 'day_id', 'seller_id');
    protected $visible = array('work_from', 'work_to', 'day_id', 'seller_id');

    public function day()
    {
        return $this->belongsTo('Day', 'day_id');
    }

    public function seller()
    {
        return $this->belongsTo('Seller', 'seller_id');
    }

}