<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorsTable extends Migration {

	public function up()
	{
		Schema::create('vendors', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('sub_dispatch_id')->unsigned();
			$table->string('name');
			$table->text('address');
			$table->integer('payment_term_id')->unsigned();
			$table->text('pickup_address');
			$table->mediumInteger('quantity');
			$table->string('email');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vendors');
	}
}