<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantsTable extends Migration {

	public function up()
	{
		Schema::create('restaurants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email');
			$table->string('phone');
			$table->integer('city_id');
			$table->string('password');
			$table->integer('delivery_category_id');
			$table->string('delivery_cost');
			$table->string('photo');
			$table->enum('availability', array('open', 'closed'));
			$table->string('api_token');
			$table->string('code');
			$table->boolean('activated');
		});
	}

	public function down()
	{
		Schema::drop('restaurants');
	}
}