<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionTable extends Migration {

	public function up()
	{
		Schema::create('subscription', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('subscription_id')->unsigned();
			$table->string('subscription_type');
			$table->date('received_date');
			$table->date('ended_date');
			$table->integer('project_id');
			$table->float('cost');
		});
	}

	public function down()
	{
		Schema::drop('subscription');
	}
}