<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeacherTable extends Migration {

	public function up()
	{
		Schema::create('teacher', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 10);
			$table->smallInteger('age')->unsigned();
			$table->string('teach_course');
			$table->string('belong_unit', 10);
			$table->string('pro_call', 10)->nullable();
			$table->bigInteger('work_num')->unsigned();
			$table->string('email', 20);
			$table->string('mobile', 15);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('teacher');
	}
}