<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MedicalFile extends Eloquent {

	protected $table = 'medical_files';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function patient()
	{
		return $this->belongsTo('Patient');
	}

	public function creator()
	{
		return $this->morphTo();
	}

	public function medicalFileShares()
	{
		return $this->hasMany('MedicalFileShare');
	}

	public function appointment()
	{
		return $this->hasOne('Appointment');
	}

}