<?php

namespace App/Models/MarketingMain;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MarketingMain extends Model 
{

    protected $table = 'marketing_mains';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function category()
    {
        return $this->belongsTo('MarketingCategory', 'marketing_category_id');
    }

    public function type()
    {
        return $this->belongsTo('MarketingType', 'marketing_type_id');
    }

}