<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSectionQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('section_questions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('section_id')->unsigned();
			$table->integer('question_id')->unsigned();
			$table->smallInteger('order')->unsigned();
			$table->string('rendertype');
			$table->integer('depends_on')->nullable();
			$table->json('depends_definition')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('section_questions');
	}
}