<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('cro_id')->references('id')->on('cros')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('section_question_id')->references('id')->on('section_questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('form_id')->references('id')->on('forms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->foreign('form_id')->references('id')->on('forms')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('section_questions', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('sections')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('section_questions', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('patients', function(Blueprint $table) {
			$table->foreign('cro_id')->references('id')->on('questions')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('patients', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('patients', function(Blueprint $table) {
			$table->foreign('operator_id')->references('id')->on('operators')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('operators', function(Blueprint $table) {
			$table->foreign('cro_id')->references('id')->on('cros')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('operators', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('sites', function(Blueprint $table) {
			$table->foreign('cro_id')->references('id')->on('cros')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->foreign('operator_id')->references('id')->on('operators')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('schedule_id')->references('id')->on('schedules')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('questionnaire_id')->references('id')->on('forms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('diary_id')->references('id')->on('diaries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('query', function(Blueprint $table) {
			$table->foreign('section_question_id')->references('id')->on('section_questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('query', function(Blueprint $table) {
			$table->foreign('answer_id')->references('id')->on('answers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('query', function(Blueprint $table) {
			$table->foreign('operator_id')->references('id')->on('operators')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('query', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('query_comments', function(Blueprint $table) {
			$table->foreign('operator_id')->references('id')->on('operators')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('query_comments', function(Blueprint $table) {
			$table->foreign('query_id')->references('id')->on('query')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('diaries', function(Blueprint $table) {
			$table->foreign('form_id')->references('id')->on('forms')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('checks_plan_events', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('checks_plan_events', function(Blueprint $table) {
			$table->foreign('check_plan_id')->references('id')->on('checks_plan')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_question_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_patient_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_cro_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_site_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_section_question_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_form_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_event_id_foreign');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->dropForeign('pages_form_id_foreign');
		});
		Schema::table('section_questions', function(Blueprint $table) {
			$table->dropForeign('section_questions_section_id_foreign');
		});
		Schema::table('section_questions', function(Blueprint $table) {
			$table->dropForeign('section_questions_question_id_foreign');
		});
		Schema::table('patients', function(Blueprint $table) {
			$table->dropForeign('patients_cro_id_foreign');
		});
		Schema::table('patients', function(Blueprint $table) {
			$table->dropForeign('patients_site_id_foreign');
		});
		Schema::table('patients', function(Blueprint $table) {
			$table->dropForeign('patients_operator_id_foreign');
		});
		Schema::table('operators', function(Blueprint $table) {
			$table->dropForeign('operators_cro_id_foreign');
		});
		Schema::table('operators', function(Blueprint $table) {
			$table->dropForeign('operators_site_id_foreign');
		});
		Schema::table('sites', function(Blueprint $table) {
			$table->dropForeign('sites_cro_id_foreign');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->dropForeign('sections_page_id_foreign');
		});
		Schema::table('invites', function(Blueprint $table) {
			$table->dropForeign('invites_operator_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_schedule_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_patient_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_questionnaire_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_diary_id_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_parent_id_foreign');
		});
		Schema::table('query', function(Blueprint $table) {
			$table->dropForeign('query_section_question_id_foreign');
		});
		Schema::table('query', function(Blueprint $table) {
			$table->dropForeign('query_answer_id_foreign');
		});
		Schema::table('query', function(Blueprint $table) {
			$table->dropForeign('query_operator_id_foreign');
		});
		Schema::table('query', function(Blueprint $table) {
			$table->dropForeign('query_event_id_foreign');
		});
		Schema::table('query_comments', function(Blueprint $table) {
			$table->dropForeign('query_comments_operator_id_foreign');
		});
		Schema::table('query_comments', function(Blueprint $table) {
			$table->dropForeign('query_comments_query_id_foreign');
		});
		Schema::table('diaries', function(Blueprint $table) {
			$table->dropForeign('diaries_form_id_foreign');
		});
		Schema::table('checks_plan_events', function(Blueprint $table) {
			$table->dropForeign('checks_plan_events_event_id_foreign');
		});
		Schema::table('checks_plan_events', function(Blueprint $table) {
			$table->dropForeign('checks_plan_events_check_plan_id_foreign');
		});
	}
}