<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->mediumText('description');
			$table->datetime('date');
			$table->string('location', 191);
			$table->integer('fee');
			$table->integer('available_seats');
			$table->integer('created_by')->unsigned();
			$table->string('asset_url');
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}