<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('vouchers', function(Blueprint $table) {
			$table->foreign('voucher_group_id')->references('id')->on('voucher_groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('voucher_statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('voucher_id')->references('id')->on('vouchers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('voucher_items', function(Blueprint $table) {
			$table->foreign('original_item_id')->references('id')->on('items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('vouchers', function(Blueprint $table) {
			$table->dropForeign('vouchers_voucher_group_id_foreign');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->dropForeign('vouchers_status_id_foreign');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->dropForeign('vouchers_user_id_foreign');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->dropForeign('vouchers_client_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_voucher_id_foreign');
		});
		Schema::table('voucher_items', function(Blueprint $table) {
			$table->dropForeign('voucher_items_original_item_id_foreign');
		});
	}
}