<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFieldSpecificGroupTable extends Migration {

	public function up()
	{
		Schema::create('field_specific_group', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('field_code');
			$table->string('major_field_code');
			$table->string('sub_major_field_code');
			$table->string('unit_field_code');
			$table->string('specific_field_code');
			$table->text('eng_specific_field')->nullable();
			$table->text('sin_specific_field')->nullable();
			$table->text('tam_specific_field')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('field_specific_group');
	}
}