<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFieldUnitGroupTable extends Migration {

	public function up()
	{
		Schema::create('field_unit_group', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('field_code');
			$table->string('major_field_code');
			$table->string('sub_major_field_code');
			$table->string('unit_field_code');
			$table->text('eng_unit_field')->nullable();
			$table->text('sin_unit_field')->nullable();
			$table->text('tam_unit_field')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('field_unit_group');
	}
}