<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->text('q_sinhala')->nullable();
			$table->text('q_english')->nullable();
			$table->text('q_tamil')->nullable();
			$table->integer('question_type')->unsigned();
			$table->decimal('total_marks');
			$table->integer('category_id');
			$table->string('field_code')->nullable();
			$table->string('major_field_code')->nullable();
			$table->string('sub_major_field_code')->nullable();
			$table->string('unit_field_code')->nullable();
			$table->string('specific_field_code')->nullable();
			$table->integer('proffession_id')->nullable();
			$table->integer('organization_id')->nullable();
			$table->integer('location_id')->nullable();
			$table->string('status')->nullable();
			$table->string('added_by')->nullable();
			$table->string('approved_by')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}