<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_tutor_id')->unsigned();
			$table->integer('user_student_id')->unsigned();
			$table->integer('subject_id')->unsigned();
			$table->string('address', 255);
			$table->datetime('start_date');
			$table->datetime('end_date');
			$table->double('lat', 10,10);
			$table->double('lng', 10,10);
			$table->timestamps();
			$table->string('description', 1000);
			$table->integer('status_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('bookings');
	}
}