<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('gender_id')->references('id')->on('user_gender')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('user_role_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_student_childrens', function(Blueprint $table) {
			$table->foreign('user_student_id')->references('id')->on('user_student')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('user_tutor_id')->references('id')->on('user_tutor')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('user_student_id')->references('id')->on('user_student')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('booking_subjects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('booking_statuses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('booking_files', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('chat_users', function(Blueprint $table) {
			$table->foreign('chat_id')->references('id')->on('chat')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('chat_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_student_settings', function(Blueprint $table) {
			$table->foreign('user_student_id')->references('id')->on('user_student')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_tutor_settings', function(Blueprint $table) {
			$table->foreign('user_tutor_id')->references('id')->on('user_tutor')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_gender_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_user_role_id_foreign');
		});
		Schema::table('user_student_childrens', function(Blueprint $table) {
			$table->dropForeign('user_student_childrens_user_student_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_user_tutor_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_user_student_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_subject_id_foreign');
		});
		Schema::table('bookings', function(Blueprint $table) {
			$table->dropForeign('bookings_status_id_foreign');
		});
		Schema::table('booking_files', function(Blueprint $table) {
			$table->dropForeign('booking_files_booking_id_foreign');
		});
		Schema::table('chat_users', function(Blueprint $table) {
			$table->dropForeign('chat_users_chat_id_foreign');
		});
		Schema::table('chat_users', function(Blueprint $table) {
			$table->dropForeign('chat_users_user_id_foreign');
		});
		Schema::table('user_student_settings', function(Blueprint $table) {
			$table->dropForeign('user_student_settings_user_student_id_foreign');
		});
		Schema::table('user_tutor_settings', function(Blueprint $table) {
			$table->dropForeign('user_tutor_settings_user_tutor_id_foreign');
		});
	}
}