<?php

namespace Models/NetworkApiCredentials;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NetworkApiCredentials extends Model 
{

    protected $table = 'network_api_credentials';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getCustomer()
    {
        return $this->belongsTo('Customers');
    }

    public function getNetorks()
    {
        return $this->belongsTo('Networks');
    }

}