<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Users extends Model 
{

    protected $table = 'Users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function role()
    {
        return $this->hasOne('Roles', 'role_id');
    }

    public function profile()
    {
        return $this->hasOne('User_profile');
    }

    public function department()
    {
        return $this->hasOne('Departments');
    }

}