<?php

namespace App/Model;

use Illuminate\Database\Eloquent\Model;

class Roll extends Model 
{

    protected $table = 'Rolls';
    public $timestamps = true;

    public function unit()
    {
        return $this->hasMany('Unit');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function manufacture()
    {
        return $this->belongsTo('Manufacturing');
    }

    public function product_id()
    {
        return $this->hasMany('Product');
    }

}