<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('Payments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id')->unsigned();
			$table->integer('payment_method_id')->unsigned();
			$table->enum('payment_term', array('For', 'EX'));
			$table->double('amount');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Payments');
	}
}