<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('Products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('Roll_id')->unsigned();
			$table->integer('total');
			$table->integer('total_weight');
			$table->integer('total_difference');
			$table->enum('product_type', array('Product_1', 'Product_2'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Products');
	}
}