<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_langue')->unsigned();
			$table->integer('id_categorie')->unsigned();
			$table->text('email');
			$table->text('password');
			$table->enum('categorie', array('rédacteur', 'correcteur', 'client', 'admin'));
			$table->boolean('etat');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}