<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('email_address');
			$table->string('website');
			$table->string('contact_name');
			$table->string('job_title');
			$table->string('company');
			$table->string('description');
			$table->string('address');
			$table->text('mobile')->nullable();
			$table->text('work_phone')->nullable();
			$table->integer('home_phone')->nullable();
			$table->string('photo');
			$table->string('meta');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}