<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('category_id')->unsigned();
			$table->string('main_image');
			$table->integer('views_count')->default('0');
			$table->timestamp('closed_at');
			$table->bigInteger('color_id')->unsigned();
			$table->decimal('total_weight_carat', 15,4);
			$table->string('shape_cut')->nullable();
			$table->string('clarity')->nullable();
			$table->boolean('is_sealed')->default(0);
			$table->boolean('is_laser_engraved')->default(0);
			$table->bigInteger('owner_id')->unsigned();
			$table->bigInteger('buyer_id')->unsigned();
			$table->boolean('is_fixed_price')->default(0);
			$table->decimal('fixed_price', 15,5)->nullable();
			$table->decimal('starting_bid', 15,2);
			$table->integer('max_payment_term');
			$table->boolean('is_admin_approval')->default(false);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}