<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_accounts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_accounts', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('account_address', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('restrict')
						->onUpdate('set null');
		});
		Schema::table('account_address', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('user_accounts', function(Blueprint $table) {
			$table->dropForeign('user_accounts_user_id_foreign');
		});
		Schema::table('user_accounts', function(Blueprint $table) {
			$table->dropForeign('user_accounts_account_id_foreign');
		});
		Schema::table('account_address', function(Blueprint $table) {
			$table->dropForeign('account_address_account_id_foreign');
		});
		Schema::table('account_address', function(Blueprint $table) {
			$table->dropForeign('account_address_address_id_foreign');
		});
	}
}