<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerCustomersTable extends Migration {

	public function up()
	{
		Schema::create('mer_customers', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->string('first_name', 255)->nullable();
			$table->string('last_name', 255)->nullable();
			$table->string('username', 255)->nullable();
			$table->string('email', 255)->unique();
			$table->string('password', 255)->nullable();
			$table->tinyInteger('status')->default('1');
			$table->string('image', 255)->nullable();
			$table->string('last_login', 255)->nullable();
			$table->string('ssn', 255)->nullable();
			$table->string('extra1', 255)->nullable();
			$table->string('extra2')->nullable()->default('255');
			$table->string('extra3')->nullable()->default('255');
			$table->string('extra4', 255)->nullable();
			$table->text('note')->nullable();
			$table->string('scope', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_customers');
	}
}