<?php

namespace Modules\Training\Entities;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TrainingSchedule extends Eloquent {

	protected $table = 'training_schedules';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function training()
	{
		return $this->belongsTo('Training');
	}

	public function enrolled_training()
	{
		return $this->hasMany('EnrolledTraining', 'schedule_id');
	}

}