<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentsTable extends Migration {

	public function up()
	{
		Schema::create('comments', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->text('text');
			$table->nullableMorphs('commentable');
			$table->bigInteger('dispute_id')->unsigned();
			$table->tinyInteger('type')->default('0');
			$table->bigInteger('parent_id')->unsigned()->nullable();
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->bigInteger('send_to')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('comments');
	}
}