<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImagesTable extends Migration {

	public function up()
	{
		Schema::create('images', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->string('description');
			$table->integer('article_id')->unsigned()->index();
			$table->string('name', 255)->unique();
			$table->timestamp('timestamps');
		});
	}

	public function down()
	{
		Schema::drop('images');
	}
}