<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('vacancies', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->foreign('vacancy_id')->references('id')->on('vacancies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->foreign('lead_id')->references('id')->on('leads')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('feedbacks', function(Blueprint $table) {
			$table->foreign('activity_id')->references('id')->on('activities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('vacancies', function(Blueprint $table) {
			$table->dropForeign('vacancies_activity_id_foreign');
		});
		Schema::table('leads', function(Blueprint $table) {
			$table->dropForeign('leads_vacancy_id_foreign');
		});
		Schema::table('files', function(Blueprint $table) {
			$table->dropForeign('files_lead_id_foreign');
		});
		Schema::table('feedbacks', function(Blueprint $table) {
			$table->dropForeign('feedbacks_activity_id_foreign');
		});
	}
}