<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Lead extends Eloquent {

	protected $table = 'leads';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'phone', 'mail', 'vacancy_id');
	protected $visible = array('name', 'phone', 'mail', 'vacancy_id');

	public function getVacancy()
	{
		return $this->hasOne('Vacancy');
	}

	public function getCity()
	{
		return $this->hasOne('City');
	}

	public function getFiles()
	{
		return $this->belongsToMany('File', 'user_id');
	}

}