<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Vacancy extends Eloquent {

	protected $table = 'vacancies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('activity_id', 'code', 'text');
	protected $visible = array('activity_id', 'code', 'text');

	public function getActivity()
	{
		return $this->hasOne('Activity');
	}

}