<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminsTable extends Migration {

	public function up()
	{
		Schema::create('admins', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('phone')->unique();
			$table->string('email')->unique();
			$table->tinyInteger('is_representative')->default('0');
			$table->string('password');
			$table->tinyInteger('status')->default('1');
			$table->string('image')->nullable();
			$table->string('admin_serial')->unique();
			$table->datetime('last_login')->nullable();
			$table->bigInteger('warehouse_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('admins');
	}
}