<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('admins', function(Blueprint $table) {
			$table->foreign('warehouse_id')->references('id')->on('warehouses')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('warehouses', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('governorate_id')->references('id')->on('governorates')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('governorates', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('main_categories', function(Blueprint $table) {
			$table->foreign('feature_id')->references('id')->on('features')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('sub_categories', function(Blueprint $table) {
			$table->foreign('main_category_id')->references('id')->on('main_categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('distribution_points', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('admins', function(Blueprint $table) {
			$table->dropForeign('admins_warehouse_id_foreign');
		});
		Schema::table('warehouses', function(Blueprint $table) {
			$table->dropForeign('warehouses_city_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_governorate_id_foreign');
		});
		Schema::table('governorates', function(Blueprint $table) {
			$table->dropForeign('governorates_country_id_foreign');
		});
		Schema::table('main_categories', function(Blueprint $table) {
			$table->dropForeign('main_categories_feature_id_foreign');
		});
		Schema::table('sub_categories', function(Blueprint $table) {
			$table->dropForeign('sub_categories_main_category_id_foreign');
		});
		Schema::table('distribution_points', function(Blueprint $table) {
			$table->dropForeign('distribution_points_city_id_foreign');
		});
	}
}