<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SessionTask extends Model 
{

    protected $table = 'stasks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function session()
    {
        return $this->belongsTo('Session', 'fk_session_id');
    }

    public function responsible()
    {
        return $this->belongsToMany('Representative', 'representatives_stasks_pivot');
    }

}