<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProdutosTable extends Migration {

	public function up()
	{
		Schema::create('produtos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('descricao');
			$table->string('vendavel');
			$table->string('preco_venda');
			$table->string('departamento')->nullable();
			$table->string('categoria')->nullable();
			$table->string('codigo');
			$table->string('tipo_preco');
			$table->string('etiqueta_unitaria');
			$table->string('sujeito_desconto');
			$table->string('tipo_desconto');
			$table->string('desconto');
			$table->string('impressora');
			$table->string('ativo');
			$table->string('codigo_eam_upc')->nullable();
			$table->string('numero_sequencia')->nullable();
			$table->string('custo')->nullable();
			$table->string('baixa_estoque');
			$table->string('vende_negativo');
			$table->string('qt_minima')->nullable();
			$table->string('qt_disponivel');
			$table->string('qt_maxima')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('produtos');
	}
}