<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Notes extends Eloquent {

	protected $table = 'notes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('violation_code', 'longitude', 'latitude', 'comment', 'direction_id', 'cause', 'status', 'redirect');

	public function type()
	{
		return $this->belongsTo('Type');
	}

	public function priority()
	{
		return $this->belongsTo('Priority');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function area()
	{
		return $this->belongsTo('Area');
	}

	public function dirction()
	{
		return $this->belongsTo('App\Models\Direction');
	}

}